<?php if (!defined('BASEPATH')) exit('No direct script access allowed');

/**
 * Cuentas
 * @author Alexis Beltran
 * 
 * @package   
 * @author erpConamype
 * @copyright satelite
 * @version 2013
 * @access public
 */
class Cuentas extends CI_Controller
{
    //EST_CREADO = 1;
    //EST_FIRMADO = 2;
    
    protected $che_add_detalle = 0;
	/**
	 * Cuentas::__construct()
	 * 
	 * @return
	 */
	function __construct()
	{
		parent::__construct();
        satelite_validar();
        $this->load->library('grocery_CRUD');
        $this->load->model('gsatelite');
        $this->load->library('Procesos');
        if (ob_get_contents()) ob_end_clean();
        date_default_timezone_set('America/El_Salvador');
	}

	/**
	 * Cuentas::index()
	 * 
	 * @return
	 */
	function index()
	{
		if (!$this->tank_auth->is_logged_in()) {
			redirect('/auth/login/');
		} else {			
			$this->_cargarvista();
		}
	}



      function get_disponible_cub($registro = 0)
    {
        $r = true;
        if( !$registro  ){ $registro = $this->input->post('chq_id'); $r = false; } 
        $this->db->join('chq_chequera', 'chq_id_cub = cub_id');
        $cuenta = $this->db->get_where('cub_cuentas_bancarias', array('chq_id'=> $registro))->row();
        if( $r ){
            return $cuenta->disponible;
        }else{
            die($cuenta->disponible);
        }
    }








    
    /**
     * Cuentas::gestion_cuentas()
     * @author Alexis Beltran
     * 
     * @return
     */
    function gestion_cuentas(){
        (new Procesos())->validar_user();
            
            $crud = new grocery_CRUD;
            $crud->set_table('cub_cuenta_bancaria')
                ->set_subject('Cuenta');
            //set_relation     
            $crud->set_relation('cub_id_ban','ban_banco','ban_nombre',array('ban_estado'=>1));
            $crud->set_relation('cub_id_orf','orf_origen_fondos','orf_nombre',array('orf_estado'=>1));
            $crud->set_relation('cub_id_tpc','tpc_tipo_cuenta','tpc_nombre',array('tpc_estado'=>1));
           // $crud->unique_fields('cub_id_ban','cub_numero');
            
            //Columns
            $crud->columns('cub_id_ban','cub_numero','cub_nombre','cub_saldo_inicial','cub_saldo','cub_fecha','cub_estado');
           
            //Display
            $crud->display_as('cub_id_ban','Banco');
            $crud->display_as('cub_fecha','Fecha de apertura');
            $crud->callback_column('cub_fecha',function($value, $row){ return ($value !="" or $value !=null )? date("d/m/Y",strtotime($value)):'';  });

            $crud->display_as('cub_estado','Estado')
                ->field_type('cub_estado', 'dropdown', array('Cerrada', 'Abierta'))
            ;
            $crud->display_as('cub_numero','Número');
            $crud->display_as('cub_nombre','Nombre');
            $crud->display_as('cub_saldo_minimo','Saldo Mínimo')
                ->callback_column('cub_saldo_minimo',array($this,'_format_money'))
            ;
            $crud->display_as('cub_saldo_inicial','Saldo Inicial')
                ->callback_column('cub_saldo_inicial',array($this,'_format_money'))
            ;
            $crud->display_as('cub_saldo','Saldo Actual');
            
            $crud->display_as('cub_id_orf','Origen de fondos');

            $crud->display_as('cub_id_tpc','Tipo de cuenta');
            

            $crud->callback_column('cub_saldo',array($this,'_cuenta_saldo'));
            
            $crud->add_action('Transacciones', '' ,'',' entypo-icon-retweet',function($primary_key , $row){
                return base_url() . "utm/transacciones/tra_consulta?cub_id=" . $row->cub_id;
            });
            //->add_action('Vendedores', '', 'cotizaciones/mantenimientos/vendedor_supervisor','icomoon-icon-stack')
     //entypo-icon-add
            $crud->add_action('Crear Chequera', '','',' entypo-icon-add chq_add',function($primary_key , $row){
                return $primary_key;
            });
            
            $crud->add_action('Ver Chequeras','','','icomoon-icon-list-view',function($primary_key , $row){
                return base_url() . "utm/cuentas/gestion_chequera?cub_id=" . $row->cub_id;
            });
                        
            $crud->add_fields('cub_id_ban','cub_numero','cub_nombre','cub_saldo_inicial','cub_saldo_minimo','cub_estado','cub_id_tpc','cub_fecha','cub_id_orf','cub_usu_mod','cub_fecha_mod');
            $crud->field_type('cub_usu_mod', 'invisible');
            $crud->field_type('cub_fecha_mod', 'invisible');
     //       $crud->field_type('cub_fecha', 'invisible');
             if(end(explode('/',uri_string()))=='add') {
            $crud->field_type('cub_estado','hidden',1);
            }
            else {
            $crud->field_type('cub_estado','dropdown', array('1' => 'Activo', '0' => 'Inactivo'));
            }

            $crud->edit_fields('cub_numero','cub_nombre','cub_saldo_minimo','cub_id_tpc','cub_fecha','cub_estado', 'cub_id_orf');
            
            //Set_rules
            $crud->set_rules('cub_numero','Número de Cuenta','required|alpha_dash|campo_unico[cub_cuenta_bancaria.cub_numero]');
            $crud->set_rules('cub_nombre','Nombre de la Cuenta','required|campo_unico[cub_cuenta_bancaria.cub_nombre]');
            $crud->set_rules('cub_saldo_inicial','Saldo Inicial','required|numeric');
            $crud->set_rules('cub_saldo_minimo','Saldo Mínimo','numeric');
            //required
            $crud->required_fields('cub_id_ban','cub_numero','cub_nombre','cub_estado','cub_saldo_inicial','cub_id_tpc');
            
           
        //Auditoria
        $crud->callback_before_insert(function($post_array){
            $post_array['cub_usu_mod'] = $this->tank_auth->get_user_id();
            $post_array['cub_fecha_mod'] = date('Y-m-d H:i:s');
       //     $post_array['cub_fecha'] = date('Y-m-d H:i:s'); //fecha de creación
            return $post_array;
        });
        $crud->callback_before_update(function($post_array){
            $post_array['cub_usu_mod'] = $this->tank_auth->get_user_id();
            $post_array['cub_fecha_mod'] = date('Y-m-d H:i:s');
            return $post_array;
        });

            $crud->unset_delete();
            
            //$crud->fields('cub_id_ban','cub_numero','cub_saldo_inicial','cub_saldo_minimo','cub_saldo');
            $crud->set_language('spanish');
            $output = $crud->render();
            $data['titulo_personal']="Gestión cuentas";
            $this->_cargarvista($data, $output);
    }
    


    /**
     * Cuentas::cuenta_add_chequera()
     * @author Alexis Beltran
     * 
     * @return
     */
    function cuenta_add_chequera(){
        (new Procesos())->validar_user(102);
        try
        {
        //if($_POST) { print_r($_POST); die(); }
            if($cub_id = $this->input->post('cub_id')){
                if($chq_id = $this->db->insert('chq_chequera',array(
                    'chq_id_cub'    =>  $cub_id,
                    'chq_numero'    =>  $this->input->post('chq_numero'),
                    'chq_numero_inicio'    =>  $this->input->post('chq_numero_inicio'),
                    'chq_cantidad'  =>  $this->input->post('chq_cantidad')
                ))){
                    die('Chequera almacenada con exito.');
                }else{
                    die('Error: No se alcanzo a almacenar');
                };
            }
            
            $data = array(
                'cub_id' => $id = $this->input->post('valor')
            );
            $this->load->view('utm/cuentas/cuenta_add_chequera',$data);
        
        }
        catch(Exception $e)
		{
			show_error($e->getMessage().' --- '.$e->getTraceAsString());
		}
    }
    
    /**
     * Cuentas::gestion_chequera()
     * @author Alexis Beltran
     * 
     * @return
     */
    function gestion_chequera(){
        (new Procesos())->validar_user();
        try
        {        
            $crud = new grocery_CRUD;
            $crud->set_table('chq_chequera');
            $crud
                ->columns('chq_id_cub', 'chq_numero', 'chq_numero_inicio', 'chq_cantidad','chq_tipo')
                ->display_as('chq_id_cub','Cuenta Bancaria')
                ->display_as('chq_numero','Número')
                ->display_as('chq_numero_inicio','Número de Cheque Inicial')
                ->display_as('chq_cantidad','Cantidad de Cheques')
                ->display_as('chq_tipo', 'Tipo')
                ->field_type('chq_tipo', 'dropdown', array(1=>'Talonario', 'Voucher'))
                ->unset_add()
                ->unset_delete()
                ;
            //$crud->
            $crud->add_action('Ver Cheques', '','','icomoon-icon-copy-2 chq_ver',function($primary_key , $row){
                return base_url() . 'utm/cuentas/gestion_cheques?chq_id=' . $primary_key;
            });
            if($cub_id =  $this->input->get('cub_id')){
                $crud->where('chq_id_cub', $cub_id);
            }
            $crud->set_primary_key('cub_id','vw_cuentas_bancarias');
            $crud->set_relation('chq_id_cub','vw_cuentas_bancarias','cuenta');
            $crud->set_language('spanish');
            $output = $crud->render();
            $data["titulo_personal"]="GESTIÓN CHEQUERA";
            $this->_cargarvista($data, $output);
        }
        catch(Exception $e)
		{
			show_error($e->getMessage().' --- '.$e->getTraceAsString());
		}
    }

    
    /**
     * Cuentas::_format_money()
     * @author Alexis Beltran
     * 
     * @param mixed $valor
     * @return
     */
    function _format_money($valor){
        return '<span style="display: inline-block">$</span><div style="display: inline-block;float: right;">' . number_format($valor,2) . '</div>';
    }
    
    /**
     * Cuentas::_format_date()
     * @author Alexis Beltran
     * 
     * @param mixed $valor
     * @return
     */
    function _format_date($valor){
        $t = explode('-',$valor);
        return '<div style="display: inline-block;float: right;">' . date('d/m/Y',mktime(0,0,0,$t[1],$t[2],$t[0])) . '</div>';
    }
    
    function che_a_firmar()
    {
        $per = new Procesos();
        $per->set_variables(1,3,102);
        //$per->validar();
        //print_r($per);
        if($per->set_next_estado($this->input->post('che_id'), 2)){
            $data['message'] = true;
            echo json_encode($data);
        }
    }
    
    function che_firmar()
    {
        $paso = 3;
        $per = new Procesos();
        $per->set_variables(1,3,102);
        $per->validar(true);
        
        $data = array(
            'titulo' => 'Cheque Firmar',
            'aceptar' => 'Firmar',
            'rechazar' => 'Rechazar',
            'url' => 'utm/cuentas/che_firmar'
        );
        
        $per->print_validar($paso, $data);
    }
    
    function che_historico()
    {    
        $per = new Procesos();
        //$per->set_variables(1);
        $id =  $this->input->post('che_id');
        $data = array(
            'tarea' => 'Cheque',
            'registro_id' => $id,
            'historico' => $per->get_historico(1, $id)
        );
        //echo  var_dump($data); die();
        $this->load->view('utm/cuentas/che_historico', $data);
    }
    
    function che_anular()
    {
         $registro =  $this->input->post('registro'); 
         $campo=$this->gsatelite->get_campo('che_cheque', 'che_numero', array('che_id'=>$registro));
         $numero_cheque=(is_object($campo))? $campo->che_numero: $campo;
        
        $paso = 12;
        $per = new Procesos();
        $per->set_variables(1,1,266);
        $per->validar();
        
        $data = array(
            'titulo' => 'Anular cheque número: '.$numero_cheque
          , 'aceptar' => 'Anular'
          , 'rechazar' => ''
          , 'url' => 'utm/cuentas/che_anular'
        );
        
        $res = $per->print_validar($paso, $data, true);
        //echo  var_dump($res); die();
        if($res =='Ok'){
            
            $tra_id = $this->gsatelite->get_campo('che_cheque', 'che_id_tra', array('che_id' => $registro));
             echo var_dump($tra_id); die();
            //actualizar la transacion 
            $this->db->update(
                'tra_transaccion'
              , array('tra_conciliado'=>-1)
              , array('tra_id'=>$tra_id)
            );
            var_dump($this->db->last_query()); die();
            die('reload');
        }
        die($res);
    }
    
    function che_sig_numero()
    {
        //echo $this->input->post('chq_id');
        $chq_id = $this->input->post('chq_id');
        if($chq_id && is_numeric($chq_id)){
            $row = $this->db->query("SELECT get_cheque_numero($chq_id) as numero;")->row();
            if($row->numero){
                $info_prefijo_sufijo = $this->db->query('SELECT * FROM chq_chequera AS chq
                    INNER JOIN `cub_cuenta_bancaria` cub ON cub.`cub_id` = chq.`chq_id_cub`
                    INNER JOIN ban_banco ban ON ban.`ban_id` = cub.`cub_id_ban`
                    WHERE chq.`chq_id`='.$chq_id)->row();
                die($info_prefijo_sufijo->ban_prefijo.$row->numero.$info_prefijo_sufijo->ban_sufijo);
            }
        }
        die('No hay Cheques Disponibles.');
    }

    function agregar_cheque(){
        satelite_validar();
        $data['prv']=$this->gsatelite->get_tabla('prv_proveedor');
        $this->gsatelite->get_tabla('che_cheque');
        $data['vwc']=$this->db->get('vw_chequeras')->result_array();
       
        $data["titulo_personal"]="Gestión Cheques";
        $this->_cargarvista($data);
    }

    function obtener_numero(){
        satelite_validar();
        $id="";
        $id=$this->input->post('chq_id');
        $numero=$this->gsatelite->get_campo('che_cheque', 'che_numero', array('che_id_chq'=>$id));
        echo $numero;
    }

    function guardar_cheque(){
        
    }

    /**
     * Cuentas::gestion_cheques()
     * @author Alexis Beltran
     * 
     * @return
     */
    function gestion_cheques(){
               satelite_validar();
        try
        {
            //$this->output->enable_profiler(TRUE);
          if($_POST) {
            $this->form_validation = FALSE;
            extract($this->input->post());
           }
            
            $per = new Procesos();
            $per->set_paso(1);
            $per->validar();
            
            $crud = new grocery_CRUD;
            $crud->set_table('che_cheque')->set_subject('Cheque');

            $crud->display_as('che_orden','A la orden de')
                ->display_as('che_numero','Número')
                ->display_as('che_fecha','Fecha')
                ->display_as('che_id_prv','Proveedor')
                ->callback_column('che_fecha',array($this,'_format_date'))
                ->display_as('che_monto','Valor del servicio')
                ->display_as('che_id_chq','Chequera')
                ->display_as('che_concepto','Concepto')

                ->display_as('che_renta','Aplica Renta')
                ->display_as('che_monto_suj','Monto sujeto a retención ')
                ->display_as('che_renta_monto','Monto de renta')
                ->display_as('che_usu_mod','Usuario')
                ->display_as('che_fecha_mod','Fecha')
                ->display_as('che_estado', 'Estado')
                ->field_type('che_renta', 'hidden')
               
                ->field_type('che_usu_mod', 'hidden', $this->tank_auth->get_user_id())
                ->field_type('che_fecha_mod', 'hidden', date('Y-m-d H:i:s'))
                //->unset_add()
                ->callback_column('che_monto',array($this,'_format_money'))
                ->callback_column('che_estado', function($value, $row){
                    $est = (new Procesos())->set_variables(1,1,266)->get_paso_actual($row->che_id);
                    if($est!=NULL){
                        return $est->pas_nombre;      
                    }   
                    });
                if(end(explode('/',uri_string()))=='add') {
                    $crud->field_type('che_estado','hidden',1);
                } else {
                    $crud->field_type('che_estado','dropdown', array('1' => 'Activo', '0' => 'Inactivo'));
                }

             $crud->set_primary_key('chq_id','vw_chequeras')
                ->set_relation('che_id_chq','vw_chequeras','{chq_numero} ({cuenta})')
                ->set_relation('che_id_prv','prv_proveedor','prv_nombre')
            ;
                    
            $crud->columns('che_id_chq','che_numero','che_monto','che_orden','che_fecha', 'che_estado','che_monto_suj','che_renta_monto');
            
            if($chq_id =  $this->input->get('chq_id')){
                $crud->where('chq_id', $chq_id);
            }
            
            //filtrado de chequere hecho en el día
            if( isset($filtros)){
                
                //chequeras en base a cuenta
                if( $cub_id > 0 ){
                    $ids = $this->db
                        ->select('Group_concat(chq_id) as ids')
                        ->from('chq_chequera')
                        ->where('chq_id_cub', $cub_id)
                        ->get()
                        ->row()
                        ->ids
                    ;
                    $ids = (strlen($ids)>0)? $ids : '0';
                    $crud->where("che_id_chq in ({$ids})");
                }
                
                //filtro por fecha
                if( strlen($fecha_desde)+strlen($fecha_hasta) > 0  )
                {
                    $crud->where('che_fecha >=', date('Y-m-d', strtotime(str_replace('/', '-',$fecha_desde))));
                    $crud->where('che_fecha <=', date('Y-m-d', strtotime(str_replace('/', '-',$fecha_hasta))));
                }
                
                //filtrado por monto
                if( $monto_desde + $monto_hasta > 0 ){
                    $crud->where('che_monto >=', $monto_desde);
                    $crud->where('che_monto <=', $monto_hasta);
                }
            }else{
                $crud->where('che_fecha', date('Y-m-d'));
                $filtros='';
            }
            
            //Procesos Creacion
            $crud->callback_add_field('che_numero', function(){ 
                return '<input id="che_numero" name="che_numero" type="text" value="Seleccione una chequera" size="100" readonly="readonly" />'; 
            });

            $crud->callback_before_insert(function($post_array, $primary_key=null){
                $post_array['che_concepto'] = htmlentities($post_array['che_concepto'] );
                if(!empty($post_array['che_renta_monto'])){
                    $post_array['che_monto'] = $post_array['che_monto'] - $post_array['che_renta_monto'];    
                }
                return $post_array; 
            });
            $crud->callback_after_insert(function($post_array,$primary_key){
                //actualizamos estado
                (new Procesos())->set_variables(1,1,266)->set_next_estado($primary_key, 1);
                //generamos la transaccion
                $cub_id = $this->db->get_where('chq_chequera', array('chq_id' => $post_array['che_id_chq']))->row()->chq_id_cub;
                $this->db->insert('tra_transaccion', array(
                    'tra_id_cub'    => $cub_id,
                    'tra_id_usu'    => $this->tank_auth->get_user_id(),
                    'tra_fecha'     => date("Y-m-d H:i:s"),
                    'tra_monto'     => -$post_array['che_monto'],
                    'tra_tipo'      => 166,
                    'tra_operacion' => $post_array['che_concepto'],
                    'tra_origen'    => 1,
                    'tra_fecha_mod'     => date("Y-m-d H:i:s"),
                    'tra_numero'    => $post_array['che_numero']
                ));
                
                //guardamos la transaccion en el cheque
                $tra_id = $this->db->insert_id(); 
                $this->db->update('che_cheque', array('che_id_tra' => $tra_id), array('che_id'=>$primary_key),1);
            });
            
            //Proceso de edicion
            $crud->callback_before_update(function($post_array, $primary_key){
                $post_array['che_concepto'] = htmlentities($post_array['che_concepto'] );
                $post_array['che_monto'] = $post_array['che_monto'] - $post_array['che_renta_monto'];
                return $post_array; 
            });     
            $crud->callback_after_update(function($post_array,$primary_key){
                //actualizamos estado
                $tra_id = $this->gsatelite->get_campo('che_cheque', 'che_id_tra', array('che_id'=>$primary_key));
                //actualizamos la transaccion
                $this->db->update(
                    'tra_transaccion'
                  , array('tra_monto' => -$post_array['che_monto'])
                  , array('tra_id' => $tra_id) 
                );
            });
            

            //Validar Historial
            //var_dump($per->validar_permiso('Historial')); die();
            if($per->validar_permiso('Historial')){                
                $crud->add_action('Historial','','','che_historico icon16 brocco-icon-clock',function($primary_key, $row){
                    return $primary_key;
                });
            }
                        
            //Agregar detalle
            if($per->validar_permiso('Crear') || $per->validar_permiso('Editar')){
                //Agregar detalle
                $crud->add_action('Detalle', '','','icon16 icomoon-icon-pencil-5', function($primary_key , $row){
                   // $est = (new Procesos())->set_variables(1,1,26)->get_paso_actual($primary_key);
                   // return ($est && $est->pas_orden <= 3)? base_url() . 'utm/cuentas/che_add_detalle/' . $row->che_id : ''; 
                    return  base_url() . 'utm/cuentas/che_add_detalle/' . $row->che_id;
                });
            }
     // Opcion 26 en opc_opcion es giro, inexistente en erp.

            //Cancelar
            if($per->validar_permiso('Cancelar')){
                $crud->add_action('Anular','', '', 'che_anular icon16 icomoon-icon-cancel-3', function($primary_key, $row){
                    $est = (new Procesos())->set_variables(1,1,266)->get_paso_actual($primary_key);
                    //print_r($est);
                    if($est != null && $est->pas_orden < 0){
                        return '';
                    }else{
                        return $primary_key;
                    }
                });
            }
            
            //Solicitar Firma
            if($per->validar_permiso('Aceptar_Denegar')){
                $crud->add_action('Solicitar Firma',base_url() . 'media/imagenes/sistema/submit_signature.png','','che_a_firmar icon16 icomoon-icon-feather',function($primary_key , $row){
                    $est = (new Procesos())->set_variables(1,1,266)->get_paso_actual($primary_key);
                    //print_r($est);
                    if($est != null && $est->pas_orden != 1){
                        return '';
                    }else{
                        return $primary_key;
                    }
                });
            }
            
            //Validar Permisos de Aceptar_Denegar
            if($per->validar_permiso('Aceptar_Denegar')){
                $crud->add_action('Firmar', base_url() . 'media/imagenes/sistema/signature.png','','che_firmar icon16 icomoon-icon-checkmark-2',function($primary_key , $row){
                    $est = $est = (new Procesos())->set_variables(1,1,266)->get_paso_actual($primary_key);
                    //print_r($est); die();
                    if($est != null && $est->pas_orden != 2){
                        return '';
                    }else{
                        return $primary_key;
                    }
                });
            }
            
            //imprimir voucher
            //if($per->validar_permiso('Imprimir')){
/*                $crud->add_action('Imprimir Voucher', '', '', 'tbutton che_voucher link_blank', function($primary_key, $row){
                    $est = (new Procesos())->set_variables(1,1,102)->get_paso_actual($primary_key);
                   return ( isset($est->pas_orden) && $est && $est->pas_orden >= 2 || $est->pas_orden <= 3 )? base_url() . 'utm/cuentas/che_voucher/' . $row->che_id : ""; 
                });*/
            //}



                /*Imprimir cheque ||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||*/
                    $crud->add_action('Imprimir Cheque', '', '', 'che_voucher link_blank icon16 icomoon-icon-printer-2', function($primary_key, $row){
                    $est = (new Procesos())->set_variables(1,1,266)->get_paso_actual($primary_key);
                            if($est != null) {
                                    return ( isset($est->pas_orden) && $est && $est->pas_orden >= 2 || $est->pas_orden <= 3 )? base_url() . 'utm/cuentas/che_voucher/' . $row->che_id : ""; 
                            }        
                });
                /*||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||*/
            
            //Validar Permisos de Creación
            if(!$per->validar_permiso('Crear')){
                //$crud->unset_add();
            }
            
            //Validar Permisos de Edición
            if(!$per->validar_permiso('Editar')){
                $crud->unset_edit();
            }
            
            //Validar Permisos de Borrado
            if(!$per->validar_permiso('Eliminar')){
                $crud->unset_delete();
            }
            
            //Validar Permisos de Exportacion
            //if(!$per->validar_permiso('Pdf')){
                $crud->unset_export();
            //}
            
            //Validar Permiso de Imprimir
            //if(!$per->validar_permiso('Imprimir')){
                $crud->unset_print();
            //}
            
            $crud->add_fields('che_id_prv','che_id_chq','che_numero','che_monto','che_orden','che_fecha','che_concepto','che_renta','che_monto_suj','che_renta_monto','che_usu_mod','che_fecha_mod','che_estado');
            $crud->edit_fields('che_orden','che_fecha','che_concepto', 'che_monto', 'che_renta','che_monto_suj','che_renta_monto');
          //  $crud->field_type('che_renta','dropdown',array('No renta','renta'));
            
            $crud->required_fields('che_id_chq','che_numero','che_orden','che_monto','che_fecha');
            $crud->set_rules('che_numero','Número','required')
                ->set_rules('che_orden','A la orden','required|alpha')
                ->set_rules('che_concepto', 'Concepto', 'required')
                ;
            $crud->set_language('spanish');

            $data = array(
                'filtros' => $filtros,
                'titulo_personal' => "Gestión Cheques"
            );
                
            $this->_cargarvista($data, $crud->render());
        
        }
        catch(Exception $e)
        {
            show_error($e->getMessage().' --- '.$e->getTraceAsString());
        }
    }
    function obtener_datos_cub()
 {
          $monto = $this->input->post('monto');
            
          $cuenta_bancaria = $this->input->post('cuenta_bancaria'); 
          $cub= $this->db->query('SELECT * FROM `chq_chequera` where chq_id ='.$cuenta_bancaria)->row_array();
          $cuenta_banco = $cub['chq_id_cub'];
         $datos_cuenta=  $this->db->query("SELECT `cub_cuenta_bancaria`.`cub_id`           AS `cub_id`,
          CONCAT(`ban_banco`.`ban_nombre`,': ',`cub_cuenta_bancaria`.`cub_numero`) AS `cuenta`,
          `cub_cuenta_bancaria`.`cub_nombre`       AS `nombre`,
          IF((COUNT(`tra_transaccion`.`tra_monto`) > 0),(`cub_cuenta_bancaria`.`cub_saldo_inicial` + SUM(`tra_transaccion`.`tra_monto`)),`cub_cuenta_bancaria`.`cub_saldo_inicial`) AS `saldo`,
          `cub_cuenta_bancaria`.`cub_saldo_minimo` AS `saldo_minimo`
        FROM ((`cub_cuenta_bancaria`
            LEFT JOIN `tra_transaccion`
              ON ((`tra_transaccion`.`tra_id_cub` = `cub_cuenta_bancaria`.`cub_id`)))
           LEFT JOIN `ban_banco`
             ON ((`cub_cuenta_bancaria`.`cub_id_ban` = `ban_banco`.`ban_id`)))
     WHERE tra_conciliado >= 0 AND cub_cuenta_bancaria.`cub_id` =".$cuenta_banco)->row_array(); 
         
         $disponible=  $datos_cuenta['saldo'];
                 if($monto <= $disponible){
                    echo 1; 
                  
                    
                }else {
                    echo 0; 
          
                }
        }
    function obtener_a_la_orden_de(){
       $id_proveedor = $this->input->post('id_proveedor');
       $proveedor = $this->db->query('select * from prv_proveedor where prv_id='.$id_proveedor)->row_array();
       echo $proveedor['prv_extender_a'];
    }
    
    function che_add_detalle($che_id = 0)
    {

        if($che_id > 0){
            
            $this->che_add_detalle = $che_id;
            $crud = new grocery_CRUD;
            $crud->set_table('dch_detalle_cheque')->set_subject('Detalle');
            $crud->display_as('dch_id_cpr','Cuenta Presupuestaria')
                ->display_as('dch_parcial','Parcial')
                ->display_as('dch_factura','Factura')
                ->display_as('dch_haber','Haber')
                ->display_as('dch_detalle_abierto','Detalle')
                ;
            $crud->where('dch_id_che', $che_id);
            $crud->columns('dch_id_cpr', 'dch_parcial', 'dch_factura','dch_detalle_abierto');
            $crud->set_relation('dch_id_cpr', 'cpr_cuenta_presupuesto', '{cpr_numero} {cpr_nombre}', "LENGTH(cpr_numero) = 5");
            $crud->add_fields('dch_id_cpr', 'dch_parcial', 'dch_factura', 'dch_detalle_abierto');
            $crud->set_rules('dch_parcial','Parcial','required|numeric|decimal');
            $crud->set_rules('dch_factura','Debe','required');
            //$crud->set_rules('dch_haber','Haber','required|decimal');
            $crud->required_fields('dch_id_cpr', 'dch_parcial');
            $crud->callback_after_insert(function($post, $primary){
               return $this->db->update('dch_detalle_cheque', array('dch_id_che' => $this->che_add_detalle), array('dch_id' => $primary)); 
            });
            $crud->edit_fields('dch_id_cpr', 'dch_parcial', 'dch_factura', 'dch_detalle_abierto');
            $crud->set_language('spanish');
            $crud->unset_export()->unset_print();
            $output = $crud->render();
            $data['titulo_personal'] = "Agregar Detalle";
            $this->_cargarvista($data, $output);
        }   
    }
    
    
    function rpt_cheques_rechazados()
    {
        //(new Procesos())->validar_user();
        try
        {
            $this->load->library('pdf');
            
            $fecha_ini = '2013-07-01';
            $fecha_fin = '2013-07-30';
            $cuenta    = 'Todas'; 
            
            //carga de datos
            $this->db->select(
 'che_cheque.che_id,
  vw_cuentas_bancarias.cub_id,
  vw_cuentas_bancarias.cuenta,
  che_cheque.che_numero,
  che_cheque.che_monto,
  che_cheque.che_orden,
  che_cheque.che_concepto,
  che_cheque.che_fecha,
  users.username,
  try_trayecto.try_fecha_fin as try_fecha,
  try_trayecto.try_obs'
            );
            $this->db->join('try_trayecto', 'che_id = try_registro_id');
            $this->db->join('pas_paso', 'try_id_pas = pas_id');
            $this->db->join('users', 'try_id_use = id');
            $this->db->join('chq_chequera', 'che_id_chq = chq_id');
            $this->db->join('vw_cuentas_bancarias', 'chq_id_cub = cub_id');
            //$this->db->where("try_fecha_fin Between '$fecha_ini' And '$fecha_fin'");
            $this->db->where(array(
                'pas_id_tar'    => 1,
                'try_aceptado'  => 3
            ));
            $this->db->group_by('che_id');
            
            $data = array(
                'cheques'   => $this->db->get('che_cheque')->result(),
                'cuenta'    => $cuenta,
                'fecha_ini' => $fecha_ini,
                'fecha_fin' => $fecha_fin,
                'titulo'    => 'Reporte de Cheques Rechazados'
            );
            
            
            $html = $this->load->view('utm/cuentas/rpt_che_rechazados', $data, true);
            
            //echo $html;
            //Impresion
            $this->pdf->setPageOrientation('L');
            $this->pdf->makePDF($html);
            
        } catch(Exception $e){
			show_error($e->getMessage().' --- '.$e->getTraceAsString());
		}
    }
    
    function rpt_cheques_anulados()
    {
        //(new Procesos())->validar_user();
        try
        {
            $this->load->library('pdf');
            
            $fecha_ini = '2013-07-01';
            $fecha_fin = '2013-07-30';
            $cuenta    = 'Todas'; 
            
            //carga de datos
            $this->db->select(
 'che_cheque.che_id,
  vw_cuentas_bancarias.cub_id,
  vw_cuentas_bancarias.cuenta,
  che_cheque.che_numero,
  che_cheque.che_monto,
  che_cheque.che_orden,
  che_cheque.che_concepto,
  che_cheque.che_fecha,
  users.username,
  try_trayecto.try_fecha_fin as try_fecha,
  try_trayecto.try_obs'
            );
            $this->db->join('try_trayecto', 'che_id = try_registro_id');
            $this->db->join('pas_paso', 'try_id_pas = pas_id');
            $this->db->join('users', 'try_id_use = id');
            $this->db->join('chq_chequera', 'che_id_chq = chq_id');
            $this->db->join('vw_cuentas_bancarias', 'chq_id_cub = cub_id');
            //$this->db->where("try_fecha_fin Between '$fecha_ini' And '$fecha_fin'");
            $this->db->where(array(
                'pas_id_tar'    => 1,
                'try_id_pas'  => 12
            ));
            $this->db->group_by('che_id');
            
            $data = array(
                'cheques'   => $this->db->get('che_cheque')->result(),
                'cuenta'    => $cuenta,
                'fecha_ini' => $fecha_ini,
                'fecha_fin' => $fecha_fin,
                'titulo'    => 'Reporte de Cheques Anulados'
            );
            
            
            $html = $this->load->view('utm/cuentas/rpt_che_rechazados', $data, true);
            
            //echo $html;
            //Impresion
            $this->pdf->setPageOrientation('L');
            $this->pdf->makePDF($html);
            
        } catch(Exception $e){
			show_error($e->getMessage().' --- '.$e->getTraceAsString());
		}
    }
    
    function che_voucher($che_id = 0)
    {

        if($che_id > 0){
            
            $this->db->select('*,
  dch_detalle_cheque.dch_id As dch_id,
  cpr_cuenta_presupuesto.cpr_numero As codigo,
  cpr_cuenta_presupuesto.cpr_nombre As cuenta,
  cpr_cuenta_presupuesto.cpr_nombre As `desc`,
  dch_detalle_cheque.dch_parcial As parcial,
  dch_detalle_cheque.dch_factura As factura
            ');
            $this->db->join('cpr_cuenta_presupuesto', 'dch_id_cpr = cpr_id', 'left');
            $detalle = $this->db->get_where('dch_detalle_cheque', array('dch_id_che' => $che_id))->result();

            $form = $this->db->query('
Select *, 
  che_cheque.che_id As che_id,
  ban_banco.ban_nombre As banco,
  cub_cuenta_bancaria.cub_numero As cuenta,
  cub_cuenta_bancaria.cub_nombre As cuenta_nombre,
  che_cheque.che_numero As cheque,
  che_cheque.che_concepto As concepto,
  che_cheque.che_monto as monto
From
  ban_banco
  Inner Join cub_cuenta_bancaria On cub_cuenta_bancaria.cub_id_ban = ban_banco.ban_id
  Inner Join chq_chequera On chq_chequera.chq_id_cub = cub_cuenta_bancaria.cub_id
  Inner Join che_cheque On che_cheque.che_id_chq = chq_chequera.chq_id
Where
  che_cheque.che_id = ' . $che_id . '
            ')->row();
            
            $che = new Procesos();
            $historico = $che->get_historico(1, $che_id);
            $history = array();
            foreach($historico as $row){
                $history[$row->paso] = $row; 
            }
            //print_r($historico); die();
           $proveed =  $form->che_id_prv;
           $data_prv= $this->db->query('select * from prv_proveedor where prv_id='.$proveed)->row_array();
            $data = array(
                'banco' => $form->banco
              , 'cuenta' => $form->cuenta
              , 'cuenta_nombre' => $form->cuenta_nombre
              , 'cheque' => $form->cheque
              , 'concepto' => $form->concepto
              , 'renta' => $form->che_renta
              , 'valor_servicio' => $form->che_monto
              , 'monto_sujeto_retencion' => $form->che_monto_suj
              , 'valor_renta' => $form->che_renta_monto
              , 'che_orden' => $form->che_orden
              , 'nit' => $data_prv['prv_nit']
              , 'form' => $form
              , 'detalle' => $detalle
              , 'creo' => $history['Creado']->username . ': ' . $history['Creado']->fecha
              //, 'autorizo' => $history['Firmado']->username . ': ' . $history['Creado']->fecha
            );
            
            
            //forma de impresion
            switch ($form->chq_tipo) {
               case 1:
                               //Cheque Voucher
                $cheque = $this->db->get_where('che_cheque',array('che_id' => $che_id), 1)->row();
                 
                $this->load->library('pdf');
                $this->load->library('texto');
                
                $borde  = 0;
                $this->pdf->SetFont('helveticaB');
                $this->pdf->setCellPaddings(0, 0, 0, 0);
                $this->pdf->SetAutoPageBreak(TRUE, 0);
                $this->pdf->SetMargins(10,0,5);
                $this->pdf->AddPage('P',
                    array(170, 215), array(
                    'family' => 'helveticaB',
                    'style'  => '',
                    'size'   => 6
                ));
                
                
                $this->pdf->SetXY(0.2, 0.2, true); 
                $this->pdf->Cell(169.6, 214.6, '', $borde, 0, 'L', false, '', 0, false, 'T', 'B');
                
                $meses = array( 1 => 'Enero','Febrero','Marzo','Abril','Mayo','Junio','Julio','Agosto','Septiembre','Octubre','Noviembre','Diciembre');
                $date = explode('-', $cheque->che_fecha);
                $fecha = $date[2] . ' de ' . $meses[(int)$date[1]] . ' de ' . $date[0];
                $fecha = strtoupper($fecha);
                $centavos = ' ' . ($cheque->che_monto - (int)$cheque->che_monto) . '/100';
                
                //fecha
                $this->pdf->SetXY(40,17); $this->pdf->Cell(80,8,'SS, '.$fecha, $borde,0,'',false,'', 3,false,'T', 'B');
                //monto
                $this->pdf->SetXY(132,17, true); $this->pdf->Cell(33,8,' '. strtoupper( number_format($cheque->che_monto,2)), $borde,0,'',false,'',0,false,'T', 'B');
                
                //AlaOrden
                $this->pdf->SetXY(25,25); $this->pdf->Cell(140,8, strtoupper($cheque->che_orden), $borde,0,'',false,'',0,false,'T', 'B');
                //textMonto
                $this->pdf->SetXY(25,33); $this->pdf->Cell(140,8, strtoupper($this->texto->ValorEnLetras((int)$cheque->che_monto,'')).$centavos , $borde,0,'',false,'',0,false,'T', 'B');            
                
                //detalle
                if(!isset($cheque->che_iva_monto)){
                    $cheque->che_iva_monto=0.0;
                }
                    $this->pdf->SetXY(10,100); $this->pdf->Cell(75,8,'RENTA RETENIDO $ '.number_format($cheque->che_renta_monto,2), $borde,0,'',false,'', 3,false,'T', 'M');
                    $this->pdf->SetXY(85,100); $this->pdf->Cell(75,8,'IVA RETENIDO   $ '.number_format($cheque->che_iva_monto,2), $borde,0,'',false,'', 3,false,'T', 'M');
                    $this->pdf->writeHTMLCell(150, 92, 10, 108, $cheque->che_concepto, $borde);    
                
                
                
                //pie
                $this->pdf->SetXY( 5, -15); $this->pdf->Cell(35, 8, '', $borde,0,'',false,'',0,false,'T', 'B');
                $this->pdf->SetXY(43, -15); $this->pdf->Cell(35, 8, '', $borde,0,'',false,'',0,false,'T', 'B');
                $this->pdf->SetXY(81, -15); $this->pdf->Cell(35, 8, '', $borde,0,'',false,'',0,false,'T', 'B');
                
                $this->pdf->SetXY(-10, -20);
                $this->pdf->StartTransform();
                $this->pdf->Rotate(90);
                $this->pdf->Cell(100,0, $cheque->che_id.'.'.$cheque->che_id_chq.'.'.$cheque->che_numero , $borde);
                $this->pdf->StopTransform();
                
                $this->pdf->boletaPDF('I');
               break;
               
               case 2:
                //Voucher Sonsonate
                $cheque = $this->db->get_where('che_cheque',array('che_id' => $che_id), 1)->row();
                $this->load->library('pdf');
                $this->load->library('texto');
                
                $borde  = 0;
                $this->pdf->SetFont('helveticaB');
                $this->pdf->setCellPaddings(0, 0, 0, 0);
                $this->pdf->SetAutoPageBreak(TRUE, 0);
                $this->pdf->SetMargins(10,0,5);
                $this->pdf->AddPage('P',
                    'letter', array(
                    'family' => 'helveticaB',
                    'style'  => '',
                    'size'   => 6
                ));
                
                
                //voucher
                $this->pdf->SetXY(12.0, 22.0, true); 
                $this->pdf->Cell(188.0, 240.0, '', $borde, 0, 'L', false, '', 0, false, 'T', 'B');
                $this->pdf->SetXY(22.0, 27.0, true); 
                $this->pdf->Cell(167.0, 69.0, '', $borde, 0, 'L', false, '', 0, false, 'T', 'B');
                
                $meses = array( 1 => 'Enero','Febrero','Marzo','Abril','Mayo','Junio','Julio','Agosto','Septiembre','Octubre','Noviembre','Diciembre');
                $date = explode('-', $cheque->che_fecha);
                $fecha = $date[2] . ' de ' . $meses[(int)$date[1]] . ' de ' . $date[0];
                $fecha = strtoupper($fecha);
                $centavos = ' ' . ($cheque->che_monto - (int)$cheque->che_monto) . '/100';
                
                //fecha
                $this->pdf->SetXY(30,33); $this->pdf->Cell(80,8,'SO, '.$fecha, $borde,0,'',false,'', 3,false,'T', 'B');
                //monto
                $this->pdf->SetXY(132,33, true); $this->pdf->Cell(33,8,' '. strtoupper( number_format($cheque->che_monto,2)), $borde,0,'',false,'',0,false,'T', 'B');
                
                //AlaOrden
                $this->pdf->SetXY(52,49); $this->pdf->Cell(136,8, strtoupper($cheque->che_orden), $borde,0,'',false,'',0,false,'T', 'B');
                //textMonto
                $this->pdf->SetXY(47,60); $this->pdf->Cell(140,8, strtoupper($this->texto->ValorEnLetras((int)$cheque->che_monto,'')).$centavos , $borde,0,'',false,'',0,false,'T', 'B');            
                
                //Cuenta
                $this->pdf->SetXY(13, 101); $this->pdf->Cell(50, 8, $data['cheque'], $borde,0,'C',false,'',0,false,'T', 'B');
                $this->pdf->SetXY(66, 101); $this->pdf->Cell(62, 8, $data['banco'], $borde,0,'C',false,'',0,false,'T', 'B');
                $this->pdf->SetXY(131, 101); $this->pdf->Cell(67, 8, $data['cuenta'], $borde,0,'C',false,'',0,false,'T', 'B');
                
                //concepto
                $this->pdf->writeHTMLCell(185, 13, 13, 117, $cheque->che_concepto, $borde, 0, false, true, 'C');
                
                //cheque
                $ay = 170;
                $ax = 30;
                
                $this->pdf->SetXY(30.0, 170.0, true); 
                $this->pdf->Cell(154.0, 70.0, '', $borde, 0, 'L', false, '', 0, false, 'T', 'B');
                
                $this->pdf->SetXY( 25+$ax, 15+$ay); $this->pdf->Cell(80,8,'SO, '.$fecha, $borde,0,'',false,'', 3,false,'T', 'B');
                $this->pdf->SetXY(113+$ax, 15+$ay, true); $this->pdf->Cell(33,8,' '. strtoupper( number_format($cheque->che_monto,2)), $borde,0,'R',false,'',0,false,'T', 'B');
                $this->pdf->SetXY( 20+$ax, 23+$ay); $this->pdf->Cell(130,7, strtoupper($cheque->che_orden), $borde,0,'',false,'',0,false,'T', 'B');
                $this->pdf->SetXY( 20+$ax, 30+$ay); $this->pdf->Cell(130,7, strtoupper($this->texto->ValorEnLetras((int)$cheque->che_monto,'')).$centavos , $borde,0,'',false,'',0,false,'T', 'B');            
                
                
                
                $this->pdf->boletaPDF('I');
               break;
               
               case 3:
               default:
               
                //Voucher Chalate
                
                $this->load->library('pdf');
                $html = $this->load->view('utm/cuentas/che_voucher',$data,true);
                //die($html);
                $this->pdf->addPagina($html, 'P');
                
                $this->pdf->boletaPDF('I');
               
            }
            
        }
    }
    
    /**
     * Cuentas::_cuenta_saldo()
     * @author Alexis Beltran
     * 
     * @param mixed $value
     * @param mixed $row
     * @return
     */
    function _cuenta_saldo($value, $row){
        
        $resultados = $this->db->get_where('vw_cuentas_bancarias',array('cub_id'=>$row->cub_id));

        if($resultados->num_rows()>0){
            $saldo = $resultados->row()->saldo; 
            $saldo_minimo=$resultados->row()->saldo_minimo; 
            if($saldo_minimo>$saldo){
                $valor=$saldo_minimo;
            }else{
                $valor=$saldo;
            }

        }else{
            $valor = 0.0;
        }
        return $this->_format_money($valor); 
    }

	/**
	 * Cuentas::_cargarvista()
	 * 
	 * @param integer $data
	 * @param integer $crud
	 * @return
	 */
	function _cargarvista($data=0,$crud=0)
	{	
		$this->load->view('vacia', $crud);	
		if($data!=0)
			$data=array_merge($data,$this->masterpage->getUsuario());
		else
			$data=$this->masterpage->getUsuario();
		$vista=$data['modulo'].'/'.$data['control'].'/'.$data['funcion'];
		$this->masterpage->setMasterPage('masterpage_default');
		$this->masterpage->addContentPage($vista, 'content',$data);
		$this->masterpage->show();
	}
}

/* End of file cuentas.php */
/* Location: ./application/controllers/bacos/cuentas.php */